//
// This file contains an 'Intel Peripheral Driver' and is
// licensed for Intel CPUs and chipsets under the terms of your
// license agreement with Intel or your vendor.  This file may
// be modified by the user, subject to additional terms of the
// license agreement
//
#------------------------------------------------------------------------------
#
# Copyright (c) 2009 - 2015, Intel Corporation. All rights reserved.<BR>
# This software and associated documentation (if any) is furnished
# under a license and may only be used or copied in accordance
# with the terms of the license. Except as permitted by such
# license, no part of this software or documentation may be
# reproduced, stored in a retrieval system, or transmitted in any
# form or by any means without the express written consent of
# Intel Corporation.
#
# Module Name:
#
#   SmiEntry.S
#
# Abstract:
#
#   Code template of the SMI handler for a particular processor
#
#------------------------------------------------------------------------------


ASM_GLOBAL  ASM_PFX(gcSmmFeatureSmiHandlerTemplate)
ASM_GLOBAL  ASM_PFX(gcSmmFeatureSmiHandlerSize)
ASM_GLOBAL  ASM_PFX(gSmmFeatureSmiCr3)
ASM_GLOBAL  ASM_PFX(gSmmFeatureSmiStack)
ASM_GLOBAL  ASM_PFX(gSmmFeatureSmbase)
ASM_GLOBAL  ASM_PFX(gSmmFeatureXdSupported)
ASM_GLOBAL  ASM_PFX(FeaturePcdGet (PcdCpuSmmStackGuard))
ASM_GLOBAL  ASM_PFX(gcSmiPMHandlerTemplate)
ASM_GLOBAL  ASM_PFX(gcSmiPMHandlerSize)
ASM_GLOBAL  ASM_PFX(gProtModeSmbase)
ASM_GLOBAL  ASM_PFX(gSmmFeatureSmiHandlerIdtr)
ASM_GLOBAL  ASM_PFX(gPMStackDesc)

.equ            MSR_EFER, 0xc0000080
.equ            MSR_EFER_XD, 0x800

.equ            DSC_OFFSET, 0xfb00
.equ            DSC_GDTPTR, 0x30
.equ            DSC_GDTSIZ, 0x38
.equ            DSC_CS, 14
.equ            DSC_DS, 16
.equ            DSC_SS, 18
.equ            DSC_OTHERSEG, 20

.equ            PROTECT_MODE_CS, 0x08
.equ            PROTECT_MODE_DS, 0x20
.equ            TSS_SEGMENT,     0x40

    .data

.align 16
ASM_PFX(gSmmFeatureSmiHandlerIdtr):
    .word  0
    .long 0
    
.equ gPMStackDescOffset, gPMStackDesc - _SmiPMEntryPoint

    .text

ASM_PFX(gcSmmFeatureSmiHandlerTemplate):

_SmiEntryPoint:
    .byte 0xbb                          # mov bx, imm16
    .word _GdtDesc - _SmiEntryPoint + 0x8000
    .byte 0x2e,0xa1                     # mov ax, cs:[offset16]
    .word DSC_OFFSET + DSC_GDTSIZ
    decl    %eax
    movl    %eax, %cs:(%edi)            # mov cs:[bx], ax
    .byte 0x66,0x2e,0xa1                # mov eax, cs:[offset16]
    .word   DSC_OFFSET + DSC_GDTPTR
    movw    %ax, %cs:2(%edi)
    movw    %ax, %bp                    # ebp = GDT base
    .byte 0x66
    lgdt    %cs:(%edi)
# Patch ProtectedMode Segment
    .byte   0xb8                        # mov ax, imm16
    .word   PROTECT_MODE_CS             # set AX for segment directly
    movl    %eax, %cs:-2(%edi)          # mov cs:[bx - 2], ax
# Patch ProtectedMode entry
    .byte 0x66, 0xbf                    # mov edi, SMBASE
ASM_PFX(gSmmFeatureSmbase): .space 4
    .byte 0x67
    lea     ((Start32bit - _SmiEntryPoint) + 0x8000)(%edi), %ax
    movw     %ax, %cs:-6(%edi)
    movl    %cr0, %ebx
    .byte 0x66
    andl    $0x9ffafff3, %ebx
    .byte 0x66
    orl     $0x23, %ebx
    movl    %ebx, %cr0
    .byte 0x66,0xea
    .space  4
    .space  2
_GdtDesc:   .space 4
            .space 2

Start32bit:
    movw    $PROTECT_MODE_DS, %ax
    movl    %eax,%ds
    movl    %eax,%es
    movl    %eax,%fs
    movl    %eax,%gs
    movl    %eax,%ss
    .byte   0xbc                          # mov esp, imm32
ASM_PFX(gSmmFeatureSmiStack): .space 4
    movl    $ASM_PFX(gSmmFeatureSmiHandlerIdtr), %eax
    lidt    (%eax)
    jmp     ProtFlatMode

ASM_PFX(gcSmiPMHandlerTemplate):
_SmiPMEntryPoint:
# when SMM PROT MODE feature is ok, processor will break here with 32bit protected mode
    .byte    0x0bf                        # mov edi, SMBASE
ASM_PFX(gProtModeSmbase):    .space    4
    # reload SS:ESP, it should be done in one instruction
    movl    $ASM_PFX(gPMStackDescOffset), %eax
    addl    %edi, %eax
    addl    $0x8000, %eax
    lss     (%eax), %esp

    # reload CS:EIP
    movl    %edi, %eax
    addl    $(ProtFlatMode - _SmiPMEntryPoint + 0x8000), %eax
    movw    $PROTECT_MODE_CS, %dx
    movw    %dx, 2(%eax)                   # mov cs:[bx - 6], eax
    movl    %eax, 6(%eax)                  # mov cs:[bx - 6], eax

    .byte   0xea                           # jmp @ProtFlatMode
    .space  6
ProtFlatMode:
    .byte   0xb8                           # mov eax, imm32
ASM_PFX(gSmmFeatureSmiCr3): .space 4
    movl    %eax, %cr3
#
# Need to test for CR4 specific bit support
#
    movl    $1, %eax
    cpuid                                  # use CPUID to determine if specific CR4 bits are supported
    xorl    %eax, %eax                     # Clear EAX
    testl   $BIT2, %edx                    # Check for DE capabilities
    jz      L8
    orl     $BIT3, %eax
L8:
    testl   $BIT6, %edx                    # Check for PAE capabilities
    jz      L9
    orl     $BIT5, %eax
L9:
    testl   $BIT7, %edx                    # Check for MCE capabilities
    jz      L10
    orl     $BIT6, %eax
L10:
    testl   $BIT24, %edx                   # Check for FXSR capabilities
    jz      L11
    orl     $BIT9, %eax
L11:
    testl   $BIT25, %edx                   # Check for SSE capabilities
    jz      L12
    orl     $BIT10, %eax
L12:                                       # as cr4.PGE is not set here, refresh cr3
    movl    %eax, %cr4                     # in PreModifyMtrrs() to flush TLB.

# enable NXE if supported
    .byte   0xb0                           # mov al, imm8
ASM_PFX(gSmmFeatureXdSupported): .space 1
    cmpb    $0, %al
    jz      L13
    movl    $MSR_EFER, %ecx
    rdmsr
    orw     $MSR_EFER_XD,%ax               # enable NXE
    wrmsr
L13:

    movl    %cr0, %ebx
    orl     $0x080000000, %ebx             # enable paging + WP
    movl    %ebx, %cr0
    leal    DSC_OFFSET(%edi),%ebx
    movw    DSC_DS(%ebx),%ax
    movl    %eax, %ds
    movw    DSC_OTHERSEG(%ebx),%ax
    movl    %eax, %es
    movl    %eax, %fs
    movl    %eax, %gs
    movw    DSC_SS(%ebx),%ax
    movl    %eax, %ss

    cmpb    $0, ASM_PFX(FeaturePcdGet (PcdCpuSmmStackGuard))
    jz      L5

# Load TSS
    movb    $0x89, (TSS_SEGMENT + 5)(%ebp) # clear busy flag
    movl    $TSS_SEGMENT, %eax
    ltrw    %ax
L5:

#   jmp     _SmmFeatureSmiHandler                 # instruction is not needed

_SmmFeatureSmiHandler:

    movl    (%esp), %ebx

    pushl   %ebx
    movl    $ASM_PFX(SmmFeatureCpuSmmDebugEntry), %eax
    call    *%eax
    popl    %ebx
    
    pushl   %ebx
    movl    $ASM_PFX(SmiRendezvous), %eax
    call    *%eax
    popl    %ebx

    pushl   %ebx
    movl    $ASM_PFX(SmmFeatureCpuSmmDebugExit), %eax
    call    *%eax
    popl    %ebx

    rsm

.align 16
# used by LSS
ASM_PFX(gPMStackDesc):
    .long 0 # to be fixed
    .long PROTECT_MODE_DS

ASM_PFX(gcSmmFeatureSmiHandlerSize):    .word      . - _SmiEntryPoint
ASM_PFX(gcSmiPMHandlerSize):  .word      . - _SmiPMEntryPoint
